/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.potions;

import com.megacrit.cardcrawl.actions.common.ApplyPowerAction;
import com.megacrit.cardcrawl.core.AbstractCreature;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.helpers.PowerTip;
import com.megacrit.cardcrawl.localization.PotionStrings;
import com.megacrit.cardcrawl.potions.AbstractPotion;
import com.megacrit.cardcrawl.powers.RegenerationPower;
import com.megacrit.cardcrawl.rooms.AbstractRoom;

public class RegenPotion
extends AbstractPotion {
    public static final String POTION_ID = "Regen Potion";
    private static final PotionStrings potionStrings = CardCrawlGame.languagePack.getPotionString("Regen Potion");
    public static final String NAME = RegenPotion.potionStrings.NAME;
    public static final String[] DESCRIPTIONS = RegenPotion.potionStrings.DESCRIPTIONS;
    public static final int healAmount = 3;

    public RegenPotion() {
        super(NAME, POTION_ID, AbstractPotion.PotionSize.M, AbstractPotion.PotionColor.CLEANSE);
        this.potency = 5;
        this.description = DESCRIPTIONS[0] + 3 + DESCRIPTIONS[1] + this.potency + DESCRIPTIONS[2];
        this.isThrown = false;
        this.tips.add(new PowerTip(this.name, this.description));
    }

    @Override
    public void use(AbstractCreature target) {
        target = AbstractDungeon.player;
        if (AbstractDungeon.getCurrRoom().phase == AbstractRoom.RoomPhase.COMBAT) {
            AbstractDungeon.actionManager.addToBottom(new ApplyPowerAction(target, AbstractDungeon.player, new RegenerationPower(target, this.potency, 3), this.potency));
        }
    }

    @Override
    public AbstractPotion makeCopy() {
        return new RegenPotion();
    }
}

